/***************************************************************** 
*  @file sep_utils.c
*  @brief 		  
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/


/************* Include Files ****************/
#include "DX_VOS_basetypes.h"
#include "msg_defs.h"
#include "sep_utils.h"
#include "extapp_err.h"


/************************ Public Functions **********************/

/**
 * @brief This function gets the message op-code.
 *
 * @param[in] msg_ptr - the SeP input message
 *
 * @return DxUint32_t - message op-code
 */
 DxUint32_t DX_SEP_GetMsgOpCode(DxUint32_t* msg_ptr)
 {
	return msg_ptr[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET];
 }


/**
 * @brief This function sets the returned error code and the message length
 *
 * @param[in] msg_ptr - the SeP input message
 * @param[in] rc - the returned error code
 * @param[in] msgParamLen - the message length in bytes. Note: this is the parameters length.
 *
 * @return DxUint32_t - message length 
 */
 DxUint32_t DX_SEP_EndMessage(DxUint32_t* msg_ptr, DxUint32_t rc, DxUint32_t msgParamLen)
 {
	DxUint32_t msgLen;	
	 
	msg_ptr[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET] = rc;
	msgLen = DX_SEP_HOST_SEP_PROTOCOL_ERR_MSG_LENGTH + msgParamLen; /* In case of error only RC is in the message */
	msg_ptr[msgLen/4 - 1] = 0x0; /* place for the checksum */

	return msgLen;
 }

